<!-- add_tank.php -->
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إضافة خزان إلى قاعدة البيانات</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            direction: rtl;
            text-align: right;
        }
        .form-control, .form-label {
            text-align: right;
        }
        .container {
            max-width: 800px;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h1 class="text-center mb-4">إضافة خزان إلى قاعدة البيانات</h1>
        <form action="store_tank.php" method="POST" enctype="multipart/form-data">
            <div class="mb-3">
                <label for="client_name" class="form-label">اسم العميل</label>
                <input type="text" class="form-control" id="client_name" name="client_name" required>
            </div>
            <div class="mb-3">
                <label for="price" class="form-label">السعر</label>
                <input type="number" class="form-control" id="price" name="price" step="0.01" required>
            </div>
            <div class="mb-3">
                <label for="sale_date" class="form-label">تاريخ البيع</label>
                <input type="date" class="form-control" id="sale_date" name="sale_date" required>
            </div>
            <div class="mb-3">
                <label for="notes" class="form-label">ملاحظات</label>
                <textarea class="form-control" id="notes" name="notes"></textarea>
            </div>
            <!-- بيانات التصميم المرسلة من الصفحة السابقة -->
            <input type="hidden" name="design_data" value='<?php echo htmlspecialchars($_POST["design_data"], ENT_QUOTES, 'UTF-8'); ?>'>
<input type="hidden" name="panel_count" value='<?php echo htmlspecialchars($_POST["panel_count"], ENT_QUOTES, 'UTF-8'); ?>'>
<input type="hidden" name="roof_panel_count" value='<?php echo htmlspecialchars($_POST["roof_panel_count"], ENT_QUOTES, 'UTF-8'); ?>'>
<input type="hidden" name="bolt_count" value='<?php echo htmlspecialchars($_POST["bolt_count"], ENT_QUOTES, 'UTF-8'); ?>'>
<input type="hidden" name="width" value='<?php echo htmlspecialchars($_POST["width"], ENT_QUOTES, 'UTF-8'); ?>'>
<input type="hidden" name="height" value='<?php echo htmlspecialchars($_POST["height"], ENT_QUOTES, 'UTF-8'); ?>'>
<input type="hidden" name="depth" value='<?php echo htmlspecialchars($_POST["depth"], ENT_QUOTES, 'UTF-8'); ?>'>
<!-- Add new fields here -->
<input type="hidden" name="stair_count" value='<?php echo htmlspecialchars($_POST["stair_count"], ENT_QUOTES, 'UTF-8'); ?>'>
<input type="hidden" name="column_count" value='<?php echo htmlspecialchars($_POST["column_count"], ENT_QUOTES, 'UTF-8'); ?>'>
<input type="hidden" name="scale_count" value='<?php echo htmlspecialchars($_POST["scale_count"], ENT_QUOTES, 'UTF-8'); ?>'>
<input type="hidden" name="roof_hole_count" value='<?php echo htmlspecialchars($_POST["roof_hole_count"], ENT_QUOTES, 'UTF-8'); ?>'>
<input type="hidden" name="pipe_hole_count" value='<?php echo htmlspecialchars($_POST["pipe_hole_count"], ENT_QUOTES, 'UTF-8'); ?>'>
<input type="hidden" name="pipe_size" value='<?php echo htmlspecialchars($_POST["pipe_size"], ENT_QUOTES, 'UTF-8'); ?>'>
<input type="hidden" name="background_color" value='<?php echo htmlspecialchars($_POST["background_color"], ENT_QUOTES, 'UTF-8'); ?>'>
<input type="hidden" name="background_image" value='<?php echo htmlspecialchars($_POST["background_image"], ENT_QUOTES, 'UTF-8'); ?>'>
<input type="hidden" name="image_as_sketch" value='<?php echo htmlspecialchars($_POST["image_as_sketch"], ENT_QUOTES, 'UTF-8'); ?>'>


            
            <div class="mb-3">
                <label for="plan_image" class="form-label">تحميل صورة المخطط</label>
                <input type="file" class="form-control" id="plan_image" name="plan_image" accept="image/*">
            </div>
            <button type="submit" class="btn btn-primary">حفظ الخزان</button>
        </form>
    </div>
</body>
</html>
